#pragma once
#include <render/integrator.h>

struct RndSampler;
struct Ray;
struct SceneAD;

struct PathWAS : UnidirectionalPathTracer
{
    PathWAS() = default;
    PathWAS(int NUM_AUX, Float base_sigma, Float power);
    Spectrum Li(const Scene &scene, const Ray &ray, RadianceQueryRecord &rRec) const override;
    void LiAD(SceneAD &sceneAD, const Ray &ray, RadianceQueryRecord &rRec, const Spectrum &d_res) const override;

    std::string getName() const override { return "PathWAS"; }

};