#include <catch2/catch.hpp>
#include <iostream>
#include <pugixml.hpp>
namespace
{
    std::string xml = R"(<?xml version="1.0"?>
    <scene version="0.5.0">
            <integrator type="path" />
            <sensor type="perspective">
                    <string name="fovAxis" value="smaller" />
                    <float name="nearClip" value="10" />
                    <float name="farClip" value="2800" />
                    <float name="focusDistance" value="1000" />
                    <transform name="toWorld">
                            <lookAt origin="278, 273, -800" target="278, 273, -799" up="0, 1, 0" />
                    </transform>
                    <float name="fov" value="39.3077" />
                    <sampler type="independent">
                            <integer name="sampleCount" value="512" />
                    </sampler>
                    <film type="hdrfilm">
                            <integer name="height" value="256" />
                            <integer name="width" value="256" />
                            <rfilter type="box" />
                    </film>
            </sensor>
            <bsdf type="diffuse" id="box">
                    <spectrum name="reflectance" value="0.725, 0.71, 0.68" />
            </bsdf>
            <bsdf type="diffuse" id="white">
                    <spectrum name="reflectance" value="0.725, 0.71, 0.68" />
            </bsdf>
            <bsdf type="diffuse" id="red">
                    <spectrum name="reflectance" value="0.63, 0.065, 0.05" />
            </bsdf>
            <bsdf type="diffuse" id="green">
                    <spectrum name="reflectance" value="0.14, 0.45, 0.091" />
            </bsdf>
            <bsdf type="diffuse" id="light">
                    <spectrum name="reflectance" value="0.0,0.0,0.0" />
            </bsdf>
            <shape type="obj">
                    <string name="filename" value="meshes/cbox_luminaire.obj" />
                    <transform name="toWorld">
                            <translate x="0" y="-0.5" z="0" />
                    </transform>
                    <ref id="light" />
                    <emitter type="area">
                            <spectrum name="radiance" value="37, 0, 0" />
                    </emitter>
            </shape>
            <shape type="obj">
                    <string name="filename" value="meshes/cbox_floor.obj" />
                    <ref id="white" />
            </shape>
            <shape type="obj">
                    <string name="filename" value="meshes/cbox_ceiling.obj" />
                    <ref id="white" />
            </shape>
            <shape type="obj">
                    <string name="filename" value="meshes/cbox_back.obj" />
                    <ref id="white" />
            </shape>
            <shape type="obj">
                    <string name="filename" value="meshes/cbox_greenwall.obj" />
                    <ref id="green" />
            </shape>
            <shape type="obj">
                    <string name="filename" value="meshes/cbox_redwall.obj" />
                    <ref id="red" />
            </shape>
            <shape type="obj">
                    <string name="filename" value="meshes/smallbox.obj" />
                    <boolean name="faceNormals" value="true" />
                    <ref id="box" />
            </shape>
            <shape type="obj">
                    <string name="filename" value="meshes/largebox.obj" />
                    <ref id="box" />
            </shape>
    </scene>)";
} // namespace

TEST_CASE("xml", "[xml]")
{
    pugi::xml_document doc;
    pugi::xml_parse_result result = doc.load_string(xml.c_str());
    std::cout << "Load result: " << result.description() << std::endl;
    doc.save(std::cout);
}