# Path-Space Differentiable Rendering of Participating Media
### [Project](https://shuangz.com/projects/psdr2-sg21) | [Paper](https://shuangz.com/projects/psdr2-sg21/psdr2-sg21.pdf) | [Supplement](https://shuangz.com/projects/psdr2-sg21/psdr2-sg21_supp.zip)

Path-Space Differentiable Rendering of Participating Media  
Cheng Zhang*, Zihan Yu*, and Shuang Zhao (* equal contribution)  
ACM Transactions on Graphics (SIGGRAPH 2021), 40(4), August 2021

## Abstract
Physics-based differentiable rendering---which focuses on estimating derivatives of radiometric detector responses with respect to arbitrary scene parameters---has a diverse array of applications from solving analysis-by-synthesis problems to training machine-learning pipelines incorporating forward-rendering processes. Unfortunately, existing general-purpose differentiable rendering techniques lack either the generality to handle volumetric light transport or the flexibility to devise Monte Carlo estimators capable of handling complex geometries and light transport effects.

In this paper, we bridge this gap by showing how generalized path integrals can be differentiated with respect to arbitrary scene parameters. Specifically, we establish the mathematical formulation of generalized differential path integrals that capture both interfacial and volumetric light transport. Our formulation allows the development of advanced differentiable rendering algorithms capable of efficiently handling challenging geometric discontinuities and light transport phenomena such as volumetric caustics.

We validate our method by comparing our derivative estimates to those generated using the finite differences. Further, to demonstrate the effectiveness of our technique, we compare both differentiable rendering and inverse rendering performance with state-of-the-art methods.

## System Requirements
Currently, our implementation only supports Linux. We have tested our implementation on Ubuntu 20.04 LTS. 

## Dependencies
We assume Python 3 is already installed. Additional dependencies can be installed via the following shell command (assuming we are using Ubuntu or other Debian-based Linux distributions): 
```bash
source install.sh
```
After installing, make sure to set the path via the following line: 
```bash
source setpath.sh
```

## Compilation
Use the following lines to compile our code:
```bash
cd vredner
mkdir build 
cd build
cmake ..
sudo make install 
```

## Running Experiments
We provide two differentiable rendering examples and one inverse rendering example in the `paper_results` directory. We can run each of them using the following commands.
### Differentiable Rendering
#### Causics
```bash
cd paper/results/diff_render/caustics
python3 validate.py
```

#### Bust
```bash
cd paper/results/diff_render/serapis
python3 validate.py
```
### Inverse Rendering

#### Caustics
```bash
cd paper/results/inv_render/caustics
python3 optimize.py
```


### Switch Between Scenes
Different scenes might have different numbers of parameters that we want to optimize and under our current implementation, we need to change that number manually in `vredner/include/config.h` and recompile. 


Uncomment one of the lines: 
```c++
// vredner/include/config.h

// Uncomment one of the following lines and recompile to run the corresponding scene
constexpr int nder = 1; // diff rendering
// constexpr int nder = 2; // inverse rendering: caustics
```


and recompile: 
```bash
cd vredner/build
sudo make install 
```

## Citation
```
@article{Zhang:2021:PSDR,
  title={Path-Space Differentiable Rendering of Participating Media},
  author={Zhang, Cheng and Yu, Zihan and Zhao, Shuang},
  journal={ACM Trans. Graph.},
  volume={40},
  number={4},
  year={2021},
  pages={76:1--76:15}
}
```