#!/bin/bash

sudo apt-get update && sudo apt-get -y upgrade

sudo apt-get install -y alien dpkg-dev debhelper build-essential cmake libtbb-dev libglfw3-dev libpython3-dev libzip-dev python3-pip libopenexr-dev pkg-config libeigen3-dev

pip3 install torch==1.8.0+cpu torchvision==0.9.0+cpu -f https://download.pytorch.org/whl/torch_stable.html
pip3 install cmake OpenEXR scikit-image pytest opencv-python==4.3.0.38 matplotlib

git clone https://github.com/libigl/libigl.git
mkdir -p dependencies
cd dependencies

git clone https://github.com/embree/embree.git
git clone https://github.com/pybind/pybind11.git

# Compile Embree
cd embree
mkdir -p build
cd build
cmake -DCMAKE_CXX_COMPILER=g++ -DCMAKE_C_COMPILER=gcc -DEMBREE_ISPC_SUPPORT=OFF ..
sudo make install -j8

# Compile Pybind11
cd ../../pybind11
mkdir -p build
cd build
cmake ..
make check -j8
sudo make install

echo '''
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/local/lib
''' >> ~/.bashrc
