#pragma once
#ifndef BSDF_NULL_H__
#define BSDF_NULL_H__

#include "bsdf.h"

struct NullBSDF: BSDF {
    Spectrum eval(const Intersection &its, const Vector &wo, EBSDFMode mode = EBSDFMode::ERadiance) const;
    SpectrumAD evalAD(const IntersectionAD &its, const VectorAD &wo, EBSDFMode mode = EBSDFMode::ERadiance) const;
    Spectrum sample(const Intersection &its, const Array3 &sample, Vector &wo, Float &pdf, Float &eta, EBSDFMode mode = EBSDFMode::ERadiance) const;
    SpectrumAD sampleAD(const IntersectionAD &its, const Array3 &rnd, VectorAD &wo, Float &pdf, Float &eta, EBSDFMode mode = EBSDFMode::ERadiance) const;
    Float pdf(const Intersection &its, const Vector &wo) const;
    inline bool isTransmissive() const { return true; }
    inline bool isTwosided() const { return true; }
    inline bool isNull() const { return true; }
    std::string toString() const {
        std::ostringstream oss;
        oss << "BSDF_null []" << std::endl;
        return oss.str();
    }
};

#endif
