#pragma once
#ifndef PATHSPACE_EDGE_MANAGER_H__
#define PATHSPACE_EDGE_MANAGER_H__

#include "edge_manager.h"
#include "sampler.h"
#include "utils.h"
#include <algorithm>
#include <iostream>
#include <vector>
#include "emitter.h"

struct EdgeRaySamplingRecord {
    Vector ref; // point on boundary
    Vector p; // point on emitter
    Float dist;
    const Emitter *emitter;
    const Edge* edge; // sampled edge
    const Shape* shape; // shape to which the sampled edge belongs to
    Ray ray; // edge ray
    Float pdf;
};

struct EdgeRaySamplingRecordAD {
    VectorAD ref; // point on boundary
    VectorAD p; // point on emitter
    FloatAD dist;
    const Emitter *emitter;
    const Edge *edge;   // sampled edge
    const Shape *shape; // shape to which the sampled edge belongs to
    RayAD ray;          // edge ray
    Float pdf;
};

struct Scene;

struct PathSpaceEdgeManager
{
    PathSpaceEdgeManager(const Scene& scene, const Eigen::Array<Float, -1, 1> &shapeWeights,
                         const Vector3i &direct_dims, const Eigen::Array<Float, -1, 1> &direct_data,
                         const Vector3i &indirect_dims, const Eigen::Array<Float, -1, 1> &indirect_data,
                         bool verbose = false);
    void initPrimaryEdges(int primary_dims, const Eigen::Array<Float, -1, 1> &data);
    void initPointLightEdges(Vector2i dims, const Eigen::Array<Float, -1, 1> &data);

    const Edge& sampleEdgeRay(const Vector &rnd3, int &shape_id, RayAD &ray, Float &pdf, bool direct = true) const;
    const Edge& samplePrimaryEdgePoint(const Float& _rnd, int &shape_id, VectorAD& p, Float &pdf) const;
    
    /**
    \brief sample a point on the boundary, sample a point light and connect them to generate an edge ray
    \return
        the sampled edge
    \param shape_id
        shape to which the edge belongs
    \param ray
        the sampled edge ray, originating from a point on edge, pointing to a point on the emitter
    \param pdf
        pdf of the sampled edge ray in discrete measure
    */
    bool sampleEdgeRayPointLight(const Vector2 &rnd2, EdgeRaySamplingRecordAD &eRec) const;


    const Scene &m_scene;

    DiscreteDistribution edge_distrbs[3];   // 0: direct; 1: indirect; 2: primary.
    std::vector<Vector2i> edge_indices[3];

    // For guided edge-ray sampling
    Vector3i grid_dims[2];
    int array_dim;
    DiscreteDistribution grid_distrbs[3];

    // For point light guiding
    Vector2i grid_dim_point_light;
    DiscreteDistribution grid_distrb_point_light;
};


#endif
