#include "area.h"
#include "intersection.h"
#include "intersectionAD.h"

Spectrum AreaLight::eval(const Intersection &its, const Vector &d) const {
    return its.geoFrame.n.dot(d) > Epsilon ? intensity.val : Spectrum::Zero();
}

SpectrumAD AreaLight::evalAD(const IntersectionAD &its, const VectorAD &d) const {
    return its.geoFrame.n.val.dot(d.val) > Epsilon ? intensity : SpectrumAD();
}

Spectrum AreaLight::eval(const Vector &norm, const Vector &d) const {
        return norm.dot(d) > Epsilon ? intensity.val : Spectrum::Zero();
}

SpectrumAD AreaLight::evalAD(const VectorAD &norm, const VectorAD &d) const {
        return norm.val.dot(d.val) > Epsilon ? intensity : SpectrumAD();
}

Float AreaLight::evalDirection(const Vector& norm, const Vector& d) const {
    Float dp = norm.dot(d);
    return dp > Epsilon ? dp : 0.0f;
}

FloatAD AreaLight::evalDirectionAD(const VectorAD& norm, const VectorAD& d) const {
    FloatAD dp = norm.dot(d);
    return dp > Epsilon ? dp : FloatAD(0.0f);
}

Float AreaLight::sampleDirection(const Array2 &rnd, Vector& dir, Float *pdf) const {
     dir = squareToCosineHemisphere(Vector2(rnd[0], rnd[1]));
     if ( pdf ) *pdf = squareToCosineHemispherePdf(dir);
     return M_PI;
}

Spectrum AreaLight::sampleDirect(const Vector2 &rnd, DirectSamplingRecord &dRec) const {
    shape_ptr->samplePosition(rnd, dRec);
    Vector dir = dRec.p - dRec.ref;
    Float dist = dir.norm();
    const Vector& light_norm = dRec.n;
    dir /= dist;
    dRec.dist = dist;
    dRec.dir = dir;
    dRec.pdf = 1.0 / shape_ptr->getArea();
    dRec.pdf *= dist * dist / light_norm.dot(-dir);
    return eval(light_norm, -dir) / dRec.pdf;
}

SpectrumAD AreaLight::sampleDirectAD(const Vector2 &rnd, DirectSamplingRecordAD &dRec) const {
    shape_ptr->samplePositionAD(rnd, dRec);
    VectorAD dir = dRec.p - dRec.ref;
    dRec.dist = dir.norm();
    FloatAD invDist = 1.0 / dRec.dist;
    dir /= dRec.dist;
    FloatAD G = dRec.n.dot(-dir) * invDist.square();
    dRec.dir = dir;
    dRec.G = G;
    dRec.pdf = 1.0 / shape_ptr->getArea();
    return evalAD(dRec.n, -dir) * G * dRec.J / dRec.pdf;
}
