#include "point.h"
#include "intersection.h"
#include "integratorAD.h"

Spectrum PointLight::eval(const Intersection &its, const Vector &d) const
{
	Float invDist = 1. / d.norm();
	return intensity.val * invDist * invDist;
}

SpectrumAD PointLight::evalAD(const IntersectionAD &its, const VectorAD &d) const
{
	FloatAD invDist = 1. / d.norm();
	return intensity * invDist * invDist;
}

Spectrum PointLight::eval(const Vector &norm, const Vector &d) const
{
	Float invDist = 1. / d.norm();
	return intensity.val * invDist * invDist;
}

SpectrumAD PointLight::evalAD(const VectorAD &norm, const VectorAD &d) const
{
	FloatAD invDist = 1. / d.norm();
	return intensity * invDist * invDist;
}

Float PointLight::evalDirection(const Vector &norm, const Vector &d) const
{
	return 1.0f;
}

FloatAD PointLight::evalDirectionAD(const VectorAD &norm, const VectorAD &d) const
{
	return FloatAD(1.0f);
}

Float PointLight::sampleDirection(const Array2 &rnd, Vector &dir, Float *pdf) const
{
	dir = squareToUniformSphere(rnd);
	if (pdf)
		*pdf = INV_FOURPI;
	// return 1.0;
	return 4 * M_PI;
}

Spectrum PointLight::sampleDirect(const Vector2 &rnd, DirectSamplingRecord &dRec) const
{
	dRec.p = pos.val;
	dRec.n = Vector::Zero();
	Vector dir = dRec.p - dRec.ref;
	Float dist = dir.norm();
	Float invDist = 1.0 / dist;
	dir /= dist;
	dRec.pdf = -1.0;
	return intensity.val * invDist * invDist;
}

SpectrumAD PointLight::sampleDirectAD(const Vector2 &rnd, DirectSamplingRecordAD &dRec) const
{
	dRec.p = pos;
	dRec.n = VectorAD(Vector::Zero());
	VectorAD dir = dRec.p - dRec.ref;
	dRec.dist = dir.norm();
	FloatAD invDist = 1.0 / dRec.dist;
	dir /= dRec.dist;
	dRec.dir = dir;
	dRec.pdf = -1.0;
	return intensity * invDist * invDist;
}

Spectrum PointLight::samplePosition(const Vector2 &rnd, PositionSamplingRecord &pRec) const {
	pRec.p = pos.val;
	pRec.n = Vector(Vector::Zero());
	pRec.pdf = 1.0f;
	return intensity.val * 4 * M_PI;
}

SpectrumAD PointLight::samplePositionAD(const Vector2 &rnd, PositionSamplingRecordAD &pRec) const {
	pRec.p = pos;
	pRec.n = VectorAD(Vector::Zero());
	pRec.pdf = 1.0f;
	return intensity * 4 * M_PI;
}