#pragma once
#include "emitter.h"
struct PointLight : Emitter
{
        PointLight() {}
        PointLight(const Spectrum3f &intensity, const Vector3f &position)
            : intensity(intensity.cast<Float>()), pos(position.cast<Float>()) {}

        PointLight(const Spectrum3f &intensity, const Vector3f &position, const ptr<float> dIntensity, const ptr<float> dPosition)
                : intensity(intensity.cast<Float>(),
                    Eigen::Map<Eigen::Array<float, nder, 3, Eigen::RowMajor>>(dIntensity.get(), nder, 3).cast<Float>()),
                pos(position.cast<Float>(),
                    Eigen::Map<Eigen::Matrix<float, 3, nder>>(dPosition.get(), 3, nder).cast<Float>()) {}

        // Return the radiant emittance for the given surface intersection
        Spectrum eval(const Intersection &its, const Vector &d) const;
        SpectrumAD evalAD(const IntersectionAD &its, const VectorAD &d) const;
        Spectrum eval(const Vector &norm, const Vector &d) const;
        SpectrumAD evalAD(const VectorAD &norm, const VectorAD &d) const;

        Float evalDirection(const Vector &norm, const Vector &d) const;
        FloatAD evalDirectionAD(const VectorAD &norm, const VectorAD &d) const;
        Float sampleDirection(const Array2 &rnd, Vector &dir, Float *pdf = nullptr) const;
        
        Spectrum sampleDirect(const Vector2 &rnd, DirectSamplingRecord &dRec) const;
        SpectrumAD sampleDirectAD(const Vector2 &rnd, DirectSamplingRecordAD &dRec) const;
        
        Spectrum samplePosition(const Vector2 &rnd, PositionSamplingRecord &pRec) const;
        SpectrumAD samplePositionAD(const Vector2 &rnd, PositionSamplingRecordAD &pRec) const;
        std::string toString() const
        {
                std::ostringstream oss;
                oss << "PointLight[" << std::endl
                    << "  intensity = "
                    << "(" << intensity(0) << "," << intensity(1) << "," << intensity(2) << ")"
                    << "]" << std::endl;
                return oss.str();
        }
        Spectrum getIntensity() const { return intensity.val; }

        SpectrumAD intensity;
        VectorAD pos;
};