#include "hybridADps.h"
#include "scene.h"

#define SAMPLE_RATIO 1

void HybridTracerADps::renderInterior(const Scene &scene, const RenderOptions &options, ptr<float> rendered_image) const
{
    const auto &camera = scene.camera;
    int num_pixels = camera.getNumPixels();
    int n_entry = num_pixels * (nder + 1) * 3;
    float *temp_image1 = new float[n_entry]();
    float *temp_image2 = new float[n_entry]();

    particleTracer.renderInterior(scene, options, temp_image1);
    auto volpathOption = options;
    volpathOption.num_samples *= SAMPLE_RATIO;
    volpathTracer.renderInterior(scene, volpathOption, temp_image2);
    for (int i = 0; i < n_entry; i++)
        rendered_image[i] = temp_image1[i] + temp_image2[i];
    delete[] temp_image1;
    delete[] temp_image2;
}