#pragma once

#include "integratorADps.h"
#include "volpathADps.h"
#include "ptracerADps.h"
#include "omp.h"

struct HybridParticleTracerADps : public ParticleTracerADps
{
    bool isHybrid() const { return true; }
};

struct HybridVolPathTracerADps : public VolPathTracerADps
{
    bool isHybrid() const { return true; }
};

struct HybridTracerADps : IntegratorAD_PathSpace
{
    HybridTracerADps() { };
    virtual ~HybridTracerADps() { };
    virtual void renderInterior(const Scene &scene, const RenderOptions &options, ptr<float> rendered_image) const;
    virtual bool isHybrid() const { return true; };
    std::string getName() const { return "hybridTracerADps (volume & new camera model)"; }
    
    HybridParticleTracerADps particleTracer;
    HybridVolPathTracerADps  volpathTracer;
};