#pragma once

#include "integratorADps.h"
#include <vector>
#include <omp.h>

struct ParticleTracerADps : IntegratorAD_PathSpace
{
        ParticleTracerADps()  { };
        virtual ~ParticleTracerADps() { };
        virtual void renderInterior(const Scene &scene, const RenderOptions &options, ptr<float> rendered_image) const;

        void traceParticleAD(const Scene &scene, RndSampler *sampler, int max_bounces, int thread_id, Float grad_threshold) const;
        void handleEmissionAD(const IntersectionAD &its, const Scene &scene, RndSampler *sampler,
                              const SpectrumAD &weight, int max_bounces, int thread_id) const;
        void handleSurfaceInteractionAD(const IntersectionAD &its, const Scene &scene, const Medium *ptr_med, RndSampler *sampler,
                                        const SpectrumAD &weight, int max_bounces, int thread_id) const;
        void handleMediumInteractionAD(const Scene &scene, const Medium *ptr_med, const RayAD &ray, RndSampler *sampler,
                                       const SpectrumAD &weight, int max_bounces, int thread_id) const;

        virtual bool isHybrid() const { return false; };
        std::string getName() const { return "ptracerADps (volume & new camera model)"; }

        mutable std::vector<std::vector<SpectrumAD>> image_per_thread;
        mutable std::vector<std::vector<EventRecordAD>> pathAD_per_thread;
        mutable std::vector<std::vector<EventRecord>> path_per_thread;
};