#pragma once
#include "integratorADps.h"

struct Ray;
struct RayAD;
struct Medium;

struct VolPathTracerADps : IntegratorAD_PathSpace
{
    VolPathTracerADps() { };
    virtual ~VolPathTracerADps() { };
    std::string getName() const { return "volpathADps"; }
    virtual bool isHybrid() const { return false; };

    // Related to INTERIOR TERM
    virtual void renderInterior(const Scene &scene, const RenderOptions &options, ptr<float> rendered_image) const;
    SpectrumAD LiAD(const Scene &scene, RndSampler *sampler, const RayAD &inRay, int pixel_x, int pixel_y, int max_depth, const Medium* med_default) const;
    SpectrumAD pixelColorAD(const Scene &scene, const RenderOptions &options, RndSampler *sampler, Float x, Float y) const;
};