#include <iostream>
#include <igl/readOBJ.h>
#include "tetra.hpp"


void tetra_test() {
    // Input polygon
    Eigen::MatrixXd V;
    Eigen::MatrixXi F;

    if ( igl::readOBJ("test2.obj", V, F) ) {
        int n = 13;
        Eigen::MatrixXd res = Eigen::MatrixXd::Zero(n, n);
        double z0 = 0.1;

        std::vector<VectorAD> vertices(V.rows());
        for ( int i = 0 ; i < V.rows(); ++i )
            vertices[i] = VectorAD(V.row(i));
        for ( int i = 0; i < 4; ++i )
            vertices[vertices.size() - 1 - i].grad() = Eigen::Vector3d(1., 0., 0.);

        std::vector<Eigen::Vector4i> faces(F.rows());
        for ( int i = 0; i < F.rows(); ++i )
            faces[i] = F.row(i);

        TetrahedronMesh tetra_mesh;
        tetra_mesh.init<4>(vertices, faces);

        Eigen::Vector3d p;
        p.z() = z0;
        for ( int i = 0; i < n; ++i ) {
            p.y() = -1. + 2.*(i + .5)/n;
            for ( int j = 0; j < n; ++j ) {
                p.x() = -1. + 2.*(j + .5)/n;

                VectorAD q;
                FloatAD J;
                bool status = tetra_mesh.query(p, q, J);
                assert(status);

                // res(i, j) = q.grad().x();
                res(i, j) = J.grad();
            }
        }

        std::cout << res << std::endl;
    }
}
